// (c) 1999 - 2025 OneSpan North America Inc. All rights reserved.


/////////////////////////////////////////////////////////////////////////////
//
//
// This file is example source code. It is provided for your information and
// assistance. See your licence agreement for details and the terms and
// conditions of the licence which governs the use of the source code. By using
// such source code you will be accepting these terms and conditions. If you do
// not wish to accept these terms and conditions, DO NOT OPEN THE FILE OR USE
// THE SOURCE CODE.
//
// Note that there is NO WARRANTY.
//
//////////////////////////////////////////////////////////////////////////////


import UIKit

class SelectTableViewCell: TableViewCell {
    @IBOutlet private weak var leftButton: UIButton!
    @IBOutlet private weak var bottomButton: UIButton!
    @IBOutlet weak var selectButton: SelectButton!
    
    private var leftAction: (() -> Void)?
    private var bottomAction: (() -> Void)?
   
    // MARK: Setter
    
    func setLeftButtonTitle(_ text: String) {
        leftButton.setTitle(text, for: .normal)
    }
    
    func setBottomButtonTitle(_ text: String) {
        bottomButton.setTitle(text, for: .normal)
    }
    
    func setLeftButtonAction(leftAction: @escaping (() -> Void)) {
        self.leftAction = leftAction
    }
    
    func setBottomButtonAction(bottomAction: @escaping (() -> Void)) {
        self.bottomAction = bottomAction
    }
    
    func setListForSelection(_ items: [SelectableItem], _ index: Int) {
        selectButton.setListForSelection(items, index)
    }
    
    func setActionOnSelection(_ action: @escaping (_ item: SelectableItem) -> Void) {
        selectButton.actionOnSelection = action
    }
    
    func setPresenter(_ presenter: UIViewController) {
        selectButton.presenter = presenter
    }
    
    func setTitleForSelection(_ text: String) {
        selectButton.selectionTitle = text
    }
    
    func setMessageForSelection(_ text: String) {
        selectButton.selectionMessage = text
    }
    
    // MARK: IBAction
    @IBAction func onLeftButtonClick(_ sender: Any) {
        leftAction?()
    }
    
    @IBAction func onBottomButtonClick(_ sender: Any) {
        bottomAction?()
    }
}
